/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanFree;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Plot {
    public static final String PROJBODY = "__PLOT__";
    protected Aladin aladin;
    protected ViewSimple viewSimple;
    protected Projection plotProj = null;
    protected ArrayList<PlotItem> plotTable = null;
    protected boolean flagTime = false;
    private static PlanFree planFree = null;
    private double[] maxTimeRange = null;
    private JButton timePlotButton = null;
    private JComboBox<String> comboX = null;
    private JComboBox<String> comboY = null;
    private JCheckBox flipX = null;
    private JCheckBox flipLog = null;

    public Plot(ViewSimple viewSimple) {
        this.aladin = viewSimple.aladin;
        this.viewSimple = viewSimple;
        if (planFree == null) {
            planFree = new PlanFree(this.aladin, PROJBODY);
        }
    }

    public Projection getProj() {
        return this.plotProj;
    }

    public String getPlotLabel() {
        StringBuffer s = new StringBuffer();
        if (this.isPlotTime()) {
            if (!this.hasTable()) {
                s.append("Time plot");
            } else {
                PlotItem p = this.getFirstPlotItem();
                Legende leg = p.plan.getFirstLegende();
                String name = leg.getName(p.index[1]);
                String desc = leg.getDescription(p.index[1]);
                String unit = leg.getUnit(p.index[1]);
                if (name != null && name.length() > 0) {
                    s.append(name);
                }
                if (unit != null && unit.length() > 0) {
                    s.append(" [" + unit + "]");
                }
                if (desc != null && desc.length() > 0) {
                    if (desc.length() > 40) {
                        desc = desc.substring(0, 36) + "...";
                    }
                    s.append(": " + desc);
                }
            }
        } else if (this.hasTable()) {
            for (int i = 0; i < 2 && i < this.plotTable.size(); ++i) {
                PlotItem p = this.plotTable.get(i);
                if (s.length() > 0) {
                    s.append(" + ");
                }
                try {
                    Legende leg = p.plan.getFirstLegende();
                    s.append(p.plan.label + "(" + leg.getName(p.index[0]) + "," + leg.getName(p.index[1]) + ")");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.plotTable.size() > 2) {
                s.append("...");
            }
        }
        return s.toString();
    }

    public void free() {
        this.plotTable = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.majProp(2);
            }
        });
    }

    public boolean hasTable() {
        return this.plotTable != null && this.plotTable.size() > 0;
    }

    public boolean isPlotTime() {
        return this.flagTime;
    }

    public boolean isPlotTimeWithoutTable() {
        return this.flagTime && !this.hasTable();
    }

    private PlotItem getFirstPlotItem() {
        if (this.plotTable == null || this.plotTable.size() == 0) {
            return null;
        }
        return this.plotTable.get(0);
    }

    protected void initPlot() {
        if (this.plotTable == null) {
            this.plotTable = new ArrayList(10);
        }
    }

    protected Plot copyIn(ViewSimple v) {
        Plot plot = new Plot(v);
        plot.plotProj = this.plotProj;
        plot.plotTable = this.plotTable == null ? null : (ArrayList)this.plotTable.clone();
        plot.flagTime = this.flagTime;
        return plot;
    }

    public void adjustPlot() {
        this.adjustPlot(null);
    }

    public void adjustPlot(PlotItem p) {
        try {
            boolean first = true;
            double min1Y = 0.0;
            double minY = 0.0;
            double max1Y = 0.0;
            double maxY = 0.0;
            double min1X = 0.0;
            double minX = 0.0;
            double max1X = 0.0;
            double maxX = 0.0;
            if (this.hasTable()) {
                PlotItem[] list;
                if (p != null) {
                    list = new PlotItem[]{p};
                } else {
                    list = new PlotItem[this.plotTable.size()];
                    this.plotTable.toArray(list);
                }
                int n = 0;
                for (PlotItem p1 : list) {
                    Iterator<Obj> it = p1.plan.iterator();
                    if (it == null) continue;
                    double[] val = null;
                    while (it.hasNext()) {
                        Source s;
                        Obj o = it.next();
                        if (!o.asSource() || Double.isNaN((val = this.getValues(val, s = (Source)o))[0]) || Double.isNaN(val[1])) continue;
                        double cX = val[0];
                        double cY = val[1];
                        ++n;
                        if (first) {
                            minX = min1X = cX;
                            max1X = min1X;
                            maxX = min1X;
                            minY = min1Y = cY;
                            max1Y = min1Y;
                            maxY = min1Y;
                            first = false;
                        }
                        if (minX > cX) {
                            minX = cX;
                        } else if (maxX < cX) {
                            maxX = cX;
                        }
                        if (cX < min1X && cX > minX || min1X == minX && cX < max1X) {
                            min1X = cX;
                        } else if (cX > max1X && cX < maxX || max1X == maxX && cX > min1X) {
                            max1X = cX;
                        }
                        if (minY > cY) {
                            minY = cY;
                        } else if (maxY < cY) {
                            maxY = cY;
                        }
                        if (cY < min1Y && cY > minY || min1Y == minY && cY < max1Y) {
                            min1Y = cY;
                            continue;
                        }
                        if (!(cY > max1Y && cY < maxY) && (max1Y != maxY || !(cY > min1Y))) continue;
                        max1Y = cY;
                    }
                    min1X = minX;
                    max1X = maxX;
                    min1Y = minY;
                    max1Y = maxY;
                }
                Aladin.trace(4, "ViewSimple.adjustPlot: " + (this.isPlotTime() ? " [plotTime]" : "") + " nsrc=" + n + " X=[" + minX + " (" + min1X + ") .. (" + max1X + ") " + maxX + "] Y=[" + minY + " (" + min1Y + ") .. (" + max1Y + ") " + maxY + "]");
            }
            double w = this.viewSimple.getWidth();
            double h = (double)this.viewSimple.getHeight() * 0.8;
            if (this.isPlotTime() || first) {
                boolean flagNoSerie = first;
                for (Plan p1 : this.aladin.calque.getPlans()) {
                    if (!p1.flagOk || !p1.active) continue;
                    double[] timeRange = p1.getTimeRange();
                    double tmin = timeRange[0];
                    double tmax = timeRange[1];
                    if (first || tmin < min1X) {
                        min1X = tmin;
                        first = false;
                    }
                    if (!first && !(tmax > max1X)) continue;
                    max1X = tmax;
                    first = false;
                }
                if (flagNoSerie && !first) {
                    max1Y = h;
                    min1Y = 0.0;
                    this.setTimePlot(true);
                }
            }
            this.memoMaxTimeRange(min1X, max1X, min1Y, max1Y);
            this.plotProj = this.plotProj != null ? new Projection(0.0, 0.0, 0.0, 0.0, max1X - min1X, max1Y - min1Y, w, h, this.plotProj.isFlipXPlot(), this.plotProj.isFlipYPlot(), this.plotProj.isLogXPlot(), this.plotProj.isLogYPlot(), (Plan)planFree) : new Projection(0.0, 0.0, 0.0, 0.0, max1X - min1X, max1Y - min1Y, w, h, false, false, false, false, (Plan)planFree);
            this.viewSimple.newView(1);
            this.viewSimple.setZoomRaDec(1.0, (min1X + max1X) / 2.0, (min1Y + max1Y) / 2.0);
            this.adjustWidgets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void memoMaxTimeRange(double jdmin, double jdmax, double ymin, double ymax) {
        this.maxTimeRange = new double[]{jdmin, jdmax, ymin, ymax};
    }

    protected void setTimeRange(double[] t) {
        if (!this.isPlotTime()) {
            return;
        }
        double w = this.viewSimple.getWidth();
        double h = (double)this.viewSimple.getHeight() * 0.8;
        double min1X = Double.isNaN(t[0]) ? this.maxTimeRange[0] : t[0];
        double max1X = Double.isNaN(t[1]) ? this.maxTimeRange[1] : t[1];
        this.plotProj = new Projection(0.0, 0.0, 0.0, 0.0, max1X - min1X, this.plotProj.rm1, w, h, this.plotProj.isFlipXPlot(), this.plotProj.isFlipYPlot(), this.plotProj.isLogXPlot(), this.plotProj.isLogYPlot(), (Plan)planFree);
        this.viewSimple.setZoomRaDec(1.0, (min1X + max1X) / 2.0, (this.maxTimeRange[2] + this.maxTimeRange[3]) / 2.0);
        this.viewSimple.newView(1);
    }

    protected double[] getTimeRange() {
        return new double[]{this.getMin(), this.getMax()};
    }

    public double[] getValues(Source s) {
        return this.getValues(null, s);
    }

    public double[] getValues(double[] val, Source s) {
        if (val == null) {
            val = new double[2];
        }
        try {
            PlotItem p = this.findPlotTable(s.plan);
            int[] index = p.index;
            if (p.isTime()) {
                val[0] = s.jdtime;
            } else {
                String sx = s.getValue(index[0]).trim();
                val[0] = Double.parseDouble(sx);
            }
            String sy = s.getValue(index[1]).trim();
            val[1] = Double.parseDouble(sy);
        }
        catch (Exception e) {
            val[0] = Double.NaN;
            val[1] = Double.NaN;
        }
        return val;
    }

    public double[] getXY(Source s) {
        return this.getXY(null, s);
    }

    public double[] getXY(double[] xy, Source s) {
        if (xy == null) {
            xy = new double[2];
        }
        if (Double.isNaN((xy = this.getValues(xy, s))[0])) {
            return xy;
        }
        Coord c = new Coord();
        try {
            c.al = xy[0];
            c.del = xy[1];
            this.plotProj.getXY(c);
            xy[0] = c.x;
            xy[1] = c.y;
        }
        catch (Exception e) {
            xy[0] = Double.NaN;
            xy[1] = Double.NaN;
        }
        return xy;
    }

    public void rmPlotTable(Plan plan) {
        PlotItem p = this.findPlotTable(plan);
        if (p == null) {
            return;
        }
        this.plotTable.remove(p);
        if (this.plotTable.size() == 0) {
            this.viewSimple.free();
        } else {
            this.viewSimple.newView(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.majProp(2);
            }
        });
    }

    public int[] addPlotTable(final Plan plan, int indexX, int indexY, boolean openProp) {
        Legende leg;
        if (this.plotTable == null) {
            this.initPlot();
        }
        if (plan.getLegende().size() > 1) {
            Aladin.error("Only the first table of this plane\ncan be drawn in a scatter plot.");
        }
        PlotItem p = this.findPlotTable(plan);
        boolean modify = true;
        boolean isTime = false;
        if (p == null) {
            p = new PlotItem();
            this.plotTable.add(p);
            modify = false;
        }
        if (indexX == -1 || indexY == -1) {
            leg = plan.getFirstLegende();
            indexX = leg.getTime();
            boolean bl = isTime = indexX >= 0;
            if (!isTime) {
                indexX = leg.getIndexNumericField();
                indexY = leg.getIndexNumericField(indexX);
            } else {
                indexY = leg.getIndexFluxField();
                if (indexY == -1 && (indexY = leg.getIndexNumericField()) == indexX) {
                    indexY = leg.getIndexNumericField(indexY);
                }
            }
        } else {
            leg = plan.getFirstLegende();
            isTime = leg.field[indexX].isTime();
        }
        p.set(plan, indexX, indexY, isTime);
        Aladin.trace(4, "ViewSimple.addPlotTable: " + (modify ? "modify" : "add") + " plan=" + plan.label + " indexX=" + indexX + " indexY=" + indexY + " isTime=" + isTime);
        final boolean flagMainPlot = this.isMainPlot(p);
        final boolean flagIsTime = isTime;
        if (flagMainPlot) {
            this.setTimePlot(isTime);
        }
        this.adjustPlot(p);
        if (openProp) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Properties.createProperties(plan);
                    Properties.majProp(2);
                    if (flagMainPlot && flagIsTime) {
                        Plot.this.timePlotButton.setEnabled(false);
                    }
                }
            });
        }
        return new int[]{indexX, indexY};
    }

    private boolean isMainPlot(PlotItem p) {
        return p == this.getFirstPlotItem();
    }

    public JPanel getPlotControlPanelForPlan(Plan plan) {
        PlotItem p = this.findPlotTable(plan);
        if (p == null) {
            return null;
        }
        return this.getPlotControlPanelForOneTable(p);
    }

    private JPanel getPlotControlPanelForOneTable(PlotItem p) {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)this.getPlotControlPanelForOneIndex(p, 0), "North");
        panel.add((Component)this.getPlotControlPanelForOneIndex(p, 1), "Center");
        panel.add((Component)this.getPlotButtonPanel(p), "South");
        return panel;
    }

    protected void toTimePlot(PlotItem p) {
        Legende leg = p.plan.getFirstLegende();
        int nindex = leg.getTime();
        if (nindex < 0) {
            return;
        }
        p.setIndex(0, nindex);
        this.comboX.setSelectedItem(leg.getNameAndDescription(nindex));
        this.setTimePlot(p.isTime());
        this.adjustPlot();
        this.viewSimple.repaint();
    }

    private void setTimePlot(boolean flag) {
        this.flagTime = flag;
    }

    private void adjustWidgets() {
        if (this.timePlotButton != null) {
            this.timePlotButton.setEnabled(!this.flagTime);
        }
        if (this.flipX != null) {
            this.flipX.setEnabled(!this.flagTime);
        }
        if (this.flipLog != null) {
            this.flipLog.setEnabled(!this.flagTime);
        }
    }

    private JPanel getPlotButtonPanel(final PlotItem p) {
        JButton b;
        JPanel panel = new JPanel();
        if (p.plan.getFirstLegende().getTime() >= 0) {
            this.timePlotButton = b = new JButton("Time plot");
            Util.toolTip(b, "Choose automatically the Time stamp column as X");
            b.setMargin(new Insets(2, 2, 2, 2));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Plot.this.toTimePlot(p);
                }
            });
            panel.add(b);
        }
        b = new JButton("zoom all");
        b.setMargin(new Insets(2, 2, 2, 2));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.this.adjustPlot();
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b);
        b = new JButton("delete");
        b.setMargin(new Insets(2, 2, 2, 2));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.this.rmPlotTable(p.plan);
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b);
        return panel;
    }

    private String getLegNameFromCombo(String s) {
        int index = s.indexOf(" - ");
        return index < 0 ? s : s.substring(0, index);
    }

    private JPanel getPlotControlPanelForOneIndex(final PlotItem p, final int n) {
        JPanel panel = new JPanel();
        Plan plan = p.plan;
        panel.add(new JLabel(n == 0 ? "X:" : "Y:"));
        Legende leg = plan.getFirstLegende();
        final JComboBox<String> combo = leg.createCombo(true);
        if (n == 0) {
            this.comboX = combo;
        } else {
            this.comboY = combo;
        }
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nindex = p.plan.getFirstLegende().find(Plot.this.getLegNameFromCombo((String)combo.getSelectedItem()));
                if (nindex == p.index[n]) {
                    return;
                }
                p.setIndex(n, nindex);
                Plot.this.setTimePlot(p.isTime());
                Plot.this.adjustPlot();
                Plot.this.viewSimple.repaint();
            }
        });
        combo.setSelectedItem(leg.getNameAndDescription(Math.abs(p.index[n])));
        panel.add(combo);
        final JCheckBox b = new JCheckBox("Flip");
        if (n == 0) {
            this.flipX = b;
        }
        if (this.plotProj != null) {
            b.setSelected(n == 0 ? this.plotProj.isFlipXPlot() : this.plotProj.isFlipYPlot());
        }
        b.setEnabled(n == 1 || !p.isTime());
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Aladin cfr_ignored_0 = Plot.this.aladin;
                Aladin.trace(4, "Plot.getPlotControlPanelForOneIndex: flipPlot(" + n + " => " + b.isSelected());
                Plot.this.plotProj.flipPlot(n, b.isSelected());
                Plot.this.adjustPlot();
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b);
        final JCheckBox b1 = new JCheckBox("Log");
        if (n == 0) {
            this.flipLog = b1;
        }
        if (this.plotProj != null) {
            b1.setSelected(n == 0 ? this.plotProj.isLogXPlot() : this.plotProj.isLogYPlot());
        }
        b1.setEnabled(n == 1 || !p.isTime());
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Aladin cfr_ignored_0 = Plot.this.aladin;
                Aladin.trace(4, "Plot.getPlotControlPanelForOneIndex: flipLog(" + n + " => " + b1.isSelected() + ")");
                Plot.this.plotProj.logPlot(n, b1.isSelected());
                Plot.this.adjustPlot();
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b1);
        return panel;
    }

    private int nbRound(double val) {
        int n;
        if (val == 0.0) {
            return 0;
        }
        if ((val = Math.abs(val)) > 1.0) {
            return 0;
        }
        for (n = 0; val < 1.0 && n < 10; val *= 10.0, ++n) {
        }
        return n;
    }

    private double getIncr(double val, int index, int sens, int n) {
        double fct = index == 0 ? this.plotProj.getFctXPlot() : this.plotProj.getFctYPlot();
        double zoom = index == 1 && this.isPlotTime() ? 1.0 : this.viewSimple.getZoom();
        double x = val * fct * zoom;
        if (n > 20) {
            return 0.0;
        }
        if (x >= 50.0 && x <= 200.0) {
            return val;
        }
        if (x < 50.0) {
            if (sens == -1) {
                return val * 2.0;
            }
            return this.getIncr(val * 10.0, index, 1, ++n);
        }
        if (sens == 1) {
            return val / 2.0;
        }
        return this.getIncr(val / 10.0, index, -1, ++n);
    }

    private double getIncrX() {
        return this.getIncr(1.0, 0, 0, 0);
    }

    private double getIncrY() {
        return this.getIncr(1.0, 1, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGrid(Graphics g, int dx, int dy) {
        try {
            double incrY;
            double incrX = this.plotProj.isLogXPlot() ? 1.0E-10 : this.getIncrX();
            double d = incrY = this.plotProj.isLogYPlot() ? 1.0E-10 : this.getIncrY();
            if (incrX == 0.0 || incrY == 0.0) {
                return;
            }
            int w = this.viewSimple.getWidth();
            int h = this.viewSimple.getHeight();
            Coord c0 = new Coord();
            PointD p = this.viewSimple.getPosition(0.0, 0.0);
            c0.x = p.x;
            c0.y = p.y;
            this.plotProj.getCoord(c0);
            Coord c1 = new Coord();
            p = this.viewSimple.getPosition((double)w, (double)h);
            c1.x = p.x;
            c1.y = p.y;
            this.plotProj.getCoord(c1);
            double initValX = this.plotProj.isLogXPlot() ? 0.0 : (double)((int)(c0.al / incrX)) * incrX;
            double initValY = this.plotProj.isLogYPlot() ? 0.0 : (double)((int)(c0.del / incrY)) * incrY;
            int nbRoundX = this.nbRound(incrX);
            int nbRoundY = this.nbRound(incrY);
            Coord c = new Coord();
            Composite saveComposite = null;
            Stroke st = null;
            try {
                String s1;
                Point p1;
                int i;
                if (g instanceof Graphics2D) {
                    saveComposite = ((Graphics2D)g).getComposite();
                    ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.aladin.view.opaciteGrid));
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    st = ((Graphics2D)g).getStroke();
                    float epaisseur = this.aladin.configuration.getGridThickness();
                    if (epaisseur <= 0.0f) {
                        float f = epaisseur = w < 1500 ? 0.5f : (float)w / 1500.0f;
                        if (epaisseur < 0.5f) {
                            epaisseur = 0.5f;
                        } else if (epaisseur > 2.0f) {
                            epaisseur = 2.0f;
                        }
                    }
                    ((Graphics2D)g).setStroke(new BasicStroke(epaisseur));
                }
                String prevDate = null;
                c.del = this.plotProj.isLogYPlot() ? 0.1 : initValY;
                c.al = initValX;
                for (i = -10; i < 200; ++i) {
                    this.plotProj.getXY(c);
                    p1 = this.viewSimple.getViewCoord(c.x, c.y);
                    if (p1 != null) {
                        g.setColor(Color.lightGray);
                        g.drawLine(p1.x + dx, 0 + dy, p1.x + dx, h + dy);
                        if (this.isPlotTime()) {
                            s1 = Astrodate.JDToDate(c.al);
                            int offset = s1.indexOf(84);
                            if (offset > 0) {
                                String d1 = s1.substring(0, offset);
                                String h1 = s1.substring(offset + 1);
                                s1 = d1.equals(prevDate) ? h1 : d1;
                                prevDate = d1;
                            }
                        } else {
                            s1 = this.plotProj.isLogXPlot() ? (i < 0 ? "1e" + i : (i == 0 ? "1" : "1e+" + i)) : c.al + "";
                        }
                        String s2 = s1.indexOf(58) >= 0 ? s1 : Util.myRound(s1, nbRoundX);
                        g.drawString(s2, p1.x + 2 + dx, h - 5 + dy);
                    }
                    if (p1 == null || p1.x + dx > w) break;
                    if (this.plotProj.isLogXPlot()) {
                        incrX *= 10.0;
                    }
                    c.al += incrX;
                }
                if (this.hasTable()) {
                    c.al = this.plotProj.isLogXPlot() ? 0.1 : initValX;
                    c.del = initValY;
                    for (i = -10; i < 200; ++i) {
                        this.plotProj.getXY(c);
                        p1 = this.viewSimple.getViewCoord(c.x, c.y);
                        if (p1 != null) {
                            g.setColor(Color.lightGray);
                            g.drawLine(0 + dx, p1.y + dy, w + dx, p1.y + dy);
                            s1 = this.plotProj.isLogYPlot() ? (i < 0 ? "1e" + i : (i == 0 ? "1" : "1e+" + i)) : c.del + "";
                            g.drawString(Util.myRound(s1, nbRoundY), 4 + dx, p1.y - 5 + dy);
                        }
                        if (p1 == null || p1.y + dy > h) break;
                        if (this.plotProj.isLogYPlot()) {
                            incrY *= 10.0;
                        }
                        c.del = c.del + (this.plotProj.isLogYPlot() ? incrY : -incrY);
                    }
                }
                if (g != null) {
                    ((Graphics2D)g).setComposite(saveComposite);
                    if (st != null) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        ((Graphics2D)g).setStroke(st);
                    }
                }
            }
            catch (Throwable throwable) {
                if (g != null) {
                    ((Graphics2D)g).setComposite(saveComposite);
                    if (st != null) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        ((Graphics2D)g).setStroke(st);
                    }
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PlotItem findPlotTable(Plan plan) {
        if (!this.hasTable()) {
            return null;
        }
        for (PlotItem p : this.plotTable) {
            if (p.plan != plan) continue;
            return p;
        }
        return null;
    }

    public double getMin() {
        return this.getValue(0.0);
    }

    public double getMax() {
        return this.getValue(this.viewSimple.getWidth());
    }

    public double getValue(double xview) {
        double val;
        try {
            PointD p = this.viewSimple.getPosition(xview, 0.0);
            Coord c = new Coord();
            c.x = p.x;
            c.y = p.y;
            this.plotProj.getCoord(c);
            val = c.al;
        }
        catch (Exception e) {
            val = Double.NaN;
        }
        return val;
    }

    protected class PlotItem {
        Plan plan;
        int[] index = new int[2];
        boolean flagIsTime = false;

        protected PlotItem() {
        }

        void set(Plan p, int indexX, int indexY, boolean isTime) {
            this.plan = p;
            this.index[0] = indexX;
            this.index[1] = indexY;
            this.flagIsTime = isTime;
        }

        void setIndex(int n, int nindex) {
            if (n == 1) {
                this.index[1] = nindex;
            } else {
                this.index[0] = nindex;
                Legende leg = this.plan.getFirstLegende();
                this.flagIsTime = leg != null && leg.getTime() == nindex;
            }
        }

        boolean isTime() {
            return this.flagIsTime;
        }

        public String toString() {
            return "Plot[" + (this.plan == null ? "null" : this.plan.label) + "] index=" + this.index[0] + "," + this.index[1] + " flagisTime=" + this.flagIsTime;
        }
    }
}

